// Part of PHSNA project.  These functions by Nick, WA5BDU
// Rev 1r9 made this file separate

//  ***** SET START-UP FREQUENCY TO USER DEFINED ********

void set_startup_fq()
{
  Serial.print(F("\r\nSet S/U freq:  'C'ontinue, 'Q'uit"));
  if ((get_char() & 0b11011111) != 'C') goto exit;

  long i_f_out;
  char choice;
  say_enter_freq();

  f_out = Serial.parseFloat();
  sendFrequency(f_out);
  Serial.print(F("Press 'Y' to write to EEPROM, 'N' to cancel"));

  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  while (!Serial.available());
  choice = toupper(Serial.read());
  if (choice != 'Y')
    goto exit;

  i_f_out = (int32_t) f_out; // set to new frequency now

  for (int i=E_su_fq; i<(E_su_fq + 4); i++) 
  {
    EEPROM.write(i, (byte) i_f_out & 0xFF);
    i_f_out >>= 8; // shift 1 byte to right
  }

exit:;
}

// *****  SET START-UP MODE TO PLX OR NORMAL TERMINAL MODE

void set_startup_mode()
{
  char choice;

  Serial.println(F("\r\nPLX mode expects to interface with Excel spreadsheet & PLX-DAQ macro."));
  Serial.println(F("Normal mode expects to interact via serial terminal & menu options."));
  
//////////////////////////////////////////AD7JT/////////////////////////////////////////////
//                        CHANGES FOR TOUCH-SCREEN OPERATION                              //
//  Serial.print(F("Press 'P' for PLX, 'N' for Normal mode, other key to cancel."));      //	
  Serial.println(F("Press:"));
  Serial.println(F("P for PLX mode"));
  Serial.println(F("N for Normal mode"));
  Serial.println(F("  Any other key to cancel."));	
//                                                                                        //
////////////////////////////////////////////////////////////////////////////////////////////

  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  while (!Serial.available());
  choice = toupper(Serial.read());
  if (choice == 'P')
  { 
    EEPROM.write(E_mode_flag, 0); // 0 for PLX mode
    Serial.println();
    Serial.println(F("Switched to PLX mode"));
    while(1); // Don't return to menu - no longer in Terminal mode
  }

  if (choice == 'N')
    EEPROM.write(E_mode_flag, 1); // NOT 0 for "normal" mode

}

// *************** TOGGLE AD9850 / AD9851 MODES ********************

void toggle_DDS_mode()
{
  char choice;

  Serial.print(F("\r\nCurrent mode: "));
  if (DDS_mode_flag)
  {
    Serial.println(F("AD9850"));
  }
  else
  {
    Serial.println(F("AD9851"));
  }

  Serial.print(F("Press 'Y' to change EEPROM flag, other key to cancel."));	

  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  while (!Serial.available());
  choice = toupper(Serial.read());
  if (choice == 'Y')

  { 
//  DDS_mode_flag ^= DDS_mode_flag; // make 0 if non-0, vice versa, via XOR////AD7JT
    DDS_mode_flag = DDS_mode_flag ? 0 : 1;/////////////////////////////////////AD7JT
    EEPROM.write(E_DDS_flag, (byte)DDS_mode_flag); 
    Serial.println();
    Serial.println(F("Done. Reset Arduino to take effect."));

  }

}


