// Add calibration routine to adjust reference frequency and save it to EEPROM (below)
// by Nick Kennedy, WA5BDU


void calibrate() {
  say_refclock_freq();
  char choice = 'X';
  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.println(F("Determines DDS reference frequency"));
  Serial.println(F("and stores it in EEPROM"));
  Serial.println();
  Serial.println(F("You adjust the DDS until you measure 10.000 MHz on"));
  Serial.println(F("your counter or standard."));
  Serial.println(); // blank line
  Serial.println(F("PRESS Y to continue or N to cancel this function"));
  while (choice != 'N' && choice != 'Y')
  {
    while (Serial.available() > 0) Serial.read();  // clear the serial buffer
    while (Serial.available() == 0);  // wait for some input
    choice = toupper(Serial.peek());
    if (choice == 'N') 
    {
      Serial.println("Function cancelled");
      goto exit;
    }

  }

  // Now we really want to do the calibration.  Set frequency to 10.000 MHz

  f_out = 10000000;
  sendFrequency(f_out);

  // Next the frequency (reference) adjustment loop
  // First, give instructions:

  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.println(); // line feed
  Serial.println(F("Press 6/7/8 to adjust freq up 1/25/100 Hz."));
  Serial.println(F("Press 5/4/3 to adjust freq down 1/25/100 Hz."));
  Serial.println();
  Serial.println(F("Press W when finished to write new reference frequency."));
  Serial.println(F("Press C to cancel without writing."));
  Serial.println(); // blank line

  while (choice != 'W' && choice != 'C')
  {
    while (Serial.available() > 0) Serial.read();  // clear the serial buffer
    while (Serial.available() == 0);  // wait for some input
    choice = toupper(Serial.peek());
    switch (choice)
    {
    case '6':
      f_clock += 1;
      break;
    case '7':
      f_clock +=25;
      break;
    case '8':
      f_clock +=100;
      break;           
    case '5':
      f_clock -= 1;
      break;
    case '4':
      f_clock -= 25;
      break;
    case '3':
      f_clock -=100;
      break;           
    }
    sendFrequency(f_out); // update with new reference clock value
  }

  // Here user's choice was C (cancel) or W (write)

  if (choice == 'W')
  {
    f_to_ee(f_clock, E_reference); // if choice was C, this step gets skipped ...
  }

exit:;

  say_refclock_freq();
  //    while (Serial.available() > 0) Serial.read();  // clear the Serial buffer  


}

void say_refclock_freq()
{
  Serial.print(F("\r\nRef clock freq: ")); //echo again 
  Serial.println(f_clock,0);
}
// ***************  CALCULATE AD8307 CONSTANTS BELOW   ******************

// by Nick Kennedy, WA5BDU

// NRK --- Add routine to calculate and save calibration constants for AD8307
// As of WA5BDU 1r4, I'll input an rf level (dBm) and read counts (ADC counts) for
// each of any number of test points from the user.  I'll need to keep track of
// their sum, the sum of their squares, the sum of their products, and number
// of input samples from the user. Using linear regression method described here:

// http://science.widener.edu/svb/stats/regress.html

void constants()
{
  float rf; // dBm, value from user input
  float rf_sum; // sum of all dBm inputs
  float rf_sq_sum; // sum of all squared dBm values
  float counts; // current counts read from ADC
  float counts_sum; // sum of all counts for all samples
  float counts_sq_sum; // sum of squares of all counts
  float rf_x_counts; // total of products of all dBm & counts pairs
  float Sxy; // Statistics term: sum of x*y - ((sum x) * (sum y))/Nsamples
  float Sxx; // Statistics term: sum of x^2 - ((sum x)^2)/Nsamples
  float Syy; //                : sum of y^2 - ((sum y)^2)/Nsamples
  // float std_dev;
  float samples; // running total number of test samples
  char anykey; 
  char choice = 'X';

  Serial.println(F("Here, the user can input from two to several known"));
  Serial.println(F("power levels in dBm. At the end, the software calculates"));
  Serial.println(F("the slope and intercept for the measurement circuit and"));
  Serial.println(F("saves to EEPROM. Option to enter values manually.\n"));
  Serial.println(F("Press 'Y' to continue, 'M' to manually enter values, other key to quit ... \n"));

  //    while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  clear_serial_buffer();
  while (!Serial.available());
  choice = toupper(Serial.read());
  if (choice != 'Y' && choice != 'M')
    goto exit;
  if (choice == 'M')
  {
    manual_slope_int();
    goto exit;
  }

  Serial.println();

  rf_sum = 0.0; //       Zero out my running totals
  rf_sq_sum = 0.0;
  counts_sum = 0.0;
  counts_sq_sum = 0.0;
  rf_x_counts = 0.0;
  samples = 0.0;

  do
  {	 
    Serial.println(F("Enter power level in dBm for this point. Enter 100 if finished."));

    //  while (Serial.available() > 0) Serial.read();  // clear the serial buffer

    Serial.println(F("Apply RF input level - enter value in dBm"));
    //	  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
    clear_serial_buffer();
    while (Serial.available() == 0); // rev 3.02 addition - prevent timeout waiting 
    rf = Serial.parseFloat();
    if (rf != 100.)
    {

      Serial.println(); 

      counts = (float)analogRead(CH0pin);
      Serial.print("counts = ");
      Serial.print(counts);
      Serial.print("  dBm = ");
      Serial.println(rf);

      counts_sum += counts;
      rf_x_counts += rf * counts; // summation of x * y, or (dBm * counts)
      counts_sq_sum += pow(counts, 2.0); //Use pow() NOT ^ for exponent. ^ is XOR
      rf_sum += rf;
      rf_sq_sum += pow(rf, 2.0);
      samples++;
    }
    else
    {
      // Here user has input all points, now calculate slope and intercept
      if (samples < 2)
      {
        Serial.println(F("Must be at least two points. Exiting ..."));
        goto exit;
      }
      Sxy = rf_x_counts - ((counts_sum * rf_sum)/samples);
      Sxx = counts_sq_sum - (pow(counts_sum, 2.0)/samples);
      Syy = rf_sq_sum - (pow(rf_sum, 2.0)/samples);
      slope = Sxy/Sxx;
      intercept = rf_sum/samples - (slope * (counts_sum/samples));
      // std_dev = sqrt((Syy -(pow(slope,2)*Sxx))/(samples-2.0)); // NRK std dev didn't have value

    }

  } 
  while (rf != 100.);

  Serial.print(F("slope = "));
  Serial.println(slope,5);
  Serial.print(F("intercept = "));
  Serial.println(intercept);
  // Serial.print(F("STD Deviation = ")); // 1r5 - std dev had no value
  // Serial.println(std_dev);
  delay (2000);
  Serial.println(F("\nPRESS Y write to EEPROM or N to cancel"));	

  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  while (!Serial.available());
  choice = toupper(Serial.read());
  if (choice == 'Y')
    slope_int_to_ee(); // write calculated values to ee

exit:;
}
// ****  NRK NRK END of the "calibrate constants" routine **********************


// NRK: Below, function to print slope / intercept from main loop()
// 1r6 change: it also checks for out of range and takes actions ...

void say_slope_int()
{
  //	Serial.println();
  Serial.println(F("Retrieved:"));
  //		say_slope_int(); // now announce what we retrieved

  if (!cal_flag)
    Serial.println(F("Using default slope/intercept"));
  Serial.print("  slope     = ");
  Serial.println(slope,5);
  Serial.print("  intercept = ");
  Serial.println(intercept);

}

