/* Return Loss Bridge addition to PHSNA
 begun 1/20/2014 - working 1/20/2014
 by Nick Kennedy WA5BDU
 Added in WA5BDU 1r11 which will soon be main revision 3.0, I think ...
 */


// RLB() is the function called from the main menu ...

void RLB()
{

  float f_low_local; // note f_low and f_high are global variables ... in kHz
  float f_high_local; // using locals here  ... in kHz
  float f_step_local; // in hertz
  float test_freq;
  float return_loss;
  float swr;
  float rho;

  float os_dBm; // dBm reading with UNKWN open or shorted
  int os_flag = 0; // non-zero means open-short measurement has been done
  unsigned int counts_old;

  char choice;
  int update; // non-zero means continuously update dBm/SWR at single freq

  Serial.println(F("\r\nReturn Loss Bridge Measurements"));
  Serial.println(F("Press R to continue, other key to exit: "));
  clear_serial_buffer();
  while (Serial.available() == 0);  // wait for some input	  
  if (toupper(Serial.peek()) != 'R') goto exit;

  do
  {
    update = 0; 
    Serial.print(F("\r\nEnter lower (or single) frequency in kHz: "));
    clear_serial_buffer();
    while (Serial.available() == 0);  // wait for some input
    while (Serial.peek() != 0x0D) f_low_local = Serial.parseFloat() * 1000.;


    Serial.println(F("Press ENTER for single frequency measurement or ..."));

    Serial.print(F("\r\nEnter higher frequency in kHz: "));
    clear_serial_buffer();
    while (Serial.available() == 0);  // wait for some input
    choice = Serial.peek();


    if (choice != 0x0D)
    {
      f_high_local = Serial.parseFloat() * 1000.; 
      Serial.print(F("\r\nEnter step value in Hz: "));
      f_step_local = Serial.parseFloat();  
    }
    else
    {
      f_step_local = 1000.; // to assure just one step
      f_high_local = f_low_local;
      Serial.print(F("\r\nContinuously update RL/SWR?  (Y/N)"));
      clear_serial_buffer();
      while (Serial.available() == 0);  // wait for some input	  
      if (toupper(Serial.peek()) == 'Y') update = 1;
    }  

    // Below, get open / shorted loss if not already done

    if (!os_flag)
    {
      sendFrequency((f_low_local + f_high_local)/2.); // Put DDS in midband for RLB open-short measurement
      Serial.println(F("\r\nShort or open the Unknown RLB port, then press a key."));
      clear_serial_buffer();
      while (!Serial.available()); // stay until user hits a key

      for (int i = 3; i > 0; i--)
      {

        CH0_ADC_counts = analogRead(CH0pin); // throw away some reads
        delay (50);
      }	   
      CH0_ADC_counts = analogRead(CH0pin);   //read the ADC
      os_dBm = counts_to_dBm();
      Serial.print(F("\r\nReading (dBm) = "));
      Serial.println(os_dBm,1); // as FYI for the user
      os_flag = 1;
    }

    Serial.println(F("\r\nConnect unknown and press any key ..."));
    clear_serial_buffer();
    while (Serial.available() == 0);  // wait for some input

    // Now ready to scan

    test_freq = f_low_local;


    // Here I do the continouous update at a single frequency

    if (update)
    {
      sendFrequency(test_freq);
      delay(50); 
      Serial.println();
      clear_serial_buffer();
      do
      {
        delay(400); // 2.5 per second
        CH0_ADC_counts = analogRead(CH0pin);
        if (counts_old != CH0_ADC_counts) // don't update if reading didn't change
        {
          counts_old = CH0_ADC_counts;
          return_loss = os_dBm - counts_to_dBm();
          swr = (pow(10, return_loss/20.)+1)/(pow(10, return_loss/20.)-1);
          Serial.print(F("\rRL: ")); // return to line start before print
          Serial.print(return_loss,1);
          Serial.print(F("SWR: "));
          Serial.print(swr,2);
          Serial.print(F("    ")); // clear out any leftover chars on the line
        }

      } 
      while (!Serial.available()); // stop if user hits key	
    }	

    else
    {

      // below, scan range

        Serial.println(F("\r\nkHz, RL, SWR, rho"));

      do
      {
        sendFrequency(test_freq);
        delay(5); 
        CH0_ADC_counts = analogRead(CH0pin);	  

        return_loss = os_dBm - counts_to_dBm();
        swr = (pow(10, return_loss/20.)+1)/(pow(10, return_loss/20.)-1);
        rho = (swr-1.)/(swr+1.);
        Serial.print(test_freq,0);
        comma_space();
        Serial.print(return_loss,1);
        comma_space();
        Serial.print(swr,2);
        comma_space();
        Serial.println(rho, 3);
        test_freq += f_step_local;
      } 
      while(test_freq < f_high_local);
    }
    Serial.println(F("Press Y to run again, other key to exit."));	
    clear_serial_buffer();
    while (Serial.available() == 0);  // wait for some input


  } 
  while (toupper(Serial.peek()) == 'Y');		  

exit:;

}


