#include <EEPROM.h>
// #include <avr/pgmspace.h>
/*************************************************************************************
 *          N E T W O R K   A N A L Y Z E R   T E R M I N A L   ( N A T )            *
 *             PHSNA firmware Version 3.02, NAT firmware Version 2.00                *
 *                              30 April 2014                                        *
 *************************************************************************************  


 
/*************************************************************************************
 *          N E T W O R K   A N A L Y Z E R   T E R M I N A L   ( N A T )            *
 *             PHSNA firmware Version 3.02, NAT firmware Version 1.00                *
 *                              Version 02.00                                        *
 *                              01 April 2014                                        *
 *************************************************************************************   
 * 
 * This modified Version 3.02 PHSNA firmware has been optimized for use with the 
 * Version 1.00 NAT firmware.  This version should also work with other terminals
 * and terminal emulators as well.  The following changes have been incorporated:
 *
 *  1.  The serial interface baud rate has been raised from 9600 to 19200 bpbs to 
 *      improve performance.
 *  2.  Menu text lines have been shortened to improve appearance on the NAT's
 *      30-character wide display.
 *  3.  The E_mode_flag is reread from EEPROM each time PLX mode is entered.
 *  4.  The PLX repeat loop has been shortened to not repeatedly access the
 *      sweep parameters.
 *  5.  The CLEARDATA Control Directive is issued later to make sure it is inside
 *      the shortened PLX repeat loop.
 *  6.  A shorter (8 characters vrs. about 28 characters) DATA Directive was 
 *      implented to speed up PLX data transfers.  This directive is in ADDITION
 *      to the original, the original is still available.  The new directive is
 *      specified by setting the PLX FLAG (spreadsheet cell number O3) to "1".
 *  7.  The end of the PLX sweep was modified to allow the NAT firmware to command
 *      it to rerun the sweep or exit PLX mode and return to menu mode.
 *  8.  Several places were changed so single character responses would be accepted
 *      with or without a following CARRIAGE RETURN.
 *  9.  A change was made so the Toggle AD9850/51 Mode (option "M" on the Options &
 *      Calibration menu) will work properly (bug fix).
 *
 *  Version 02.00
 *  1.  Many menu changes to accomodate NAT screen and touch screen options and menus.
 *
 *  All of these changes are identified with my call sign ("AD7JT") in the comments
 *  so they can easilly be found by searching for my call sign.
 *
 *  Please direct all comments, critiques, suggestions, bug reports, etc. to me.
 *            Dave Collins - AD7JT
 *            ad7jt@dnbrealty.com
 *                                                                                    
 **************************************************************************************/
/* NRK this change is made on rev2.62, revision WA5BDU 1.2, now 1.3
/* NRK this change is made on rev2.62, revision WA5BDU 1.2, now 1.3
 * Added calibrate routine to find actual clock frequency and burn
 * to EEPROM, to be re-loaded on each start-up.
 * Changed individual routines so when they end, or are ended by user
 * program returns to the main menu.
 * Added a start-up frequency the DDS is set to without any user input
 * required. Startup frequency is announced over the serial port. 
 * Nick, WA5BDU 11/21/2013
 * 
 * Revision WA5BDU 1r1 incorporates a routine to calculate the constants
 * for the AD8307 chip plus amplifier.  
 * 
 * November 27, 2013 - working on 2r62.  The first change is not visible to
 * the end user, but I'm adding use of PROGMEM or pgmspace.h so we can 
 * store strings in flash memory and not overload limited SRAM.
 * 
 * The other change for 2r62 WA5BDU 1r3 is to add the ability to write the calculated
 * slope and intercept for the AD8307 circuit to EEPROM for use each time
 * the program starts.
 * 
 * November 29, 2013 - My revision 1r4 to 2r62.  Plan to fix quick time-out when
 * user is inputting calibration values for slope / intercept, and add multi-point
 * slope / intercept calculation using least squares regression as requested by Jim G.
 * 
 * December 6, 2013 - 1r5 I want to take the 1 MHz lower limit off of the Generator 
 * option and see if we can do OK at 455 kHz or even 100 kHz.
 * 
 * December 13, 2013 - 1r6 will merge the PLX-DAQ version from Jack Generaux W0FNQ
 * with the original verions.  It will detect the PLX-DAQ Excel macro if connected,
 * otherwise will default to the terminal version.
 * 
 * December 21, 2013 - WA5BDU 1r7 does automatic scan of a crystal or similar 
 * resonator and calculates its equivalent parameters.  A reading of the loss thru
 * the shorted crystal fixture is provided, and the results may be saved to eeprom.
 * After one scan, repeats are possible without re-entering parameters.
 * 
 * December 28, 2013 - WA5BDU 1r8.  First, PLX-DAQ is unaware of the shorted crystal
 * fixture loss factor.  I'm setting cell O4=100 in PLX-DAQ's spreadsheet to clue this
 * program to use the loss factor in the dBm value returned to PLX.  In this way,
 * a crystal scan will have a 0 dB reference.
 * 
 * Also as part of 1r8, I'd going to add a flag for AD9850 versus AD9851 and associated
 * changes in reference frequency and addressing the chip(s) to accommodate the one
 * in use.  Note that the setup() routine already has a pluse of W_CLK followed by 
 * a pluse of FQ_UD, so I shouldn't need to add an initialize section for the AD9851.
 * 
 * Revision 1r9 added ability to switch between AD9850 and AD9851 modes (fixed a bug in 1r8)
 * In generator mode, added the ability to have the dBm reading updated continuously.  In
 * the SNA function, added the option to display raw dBm readings in addition to frequency
 * compensated ones.  Broke the source code down into smaller files.
 * 
 * January 16, 2014 Added ability to assign an identifier to crystals, and also  crystal
 * data is printed out on a comma delimited line.
 * 
 */

/*
* rev 2.62 on 21 November 2013
 * Original AD9851 DDS sketch by Andrew Smallbone at www.rocketnumbernine.com
 * Modified by NR8O for testing the inexpensive AD9850 ebay DDS modules
 * Use freely
 * Pictures and pinouts at nr8o.dhlpilotcentral.com
 *
 * 9850 datasheet at
 * http://www.analog.com/static/imported-files/data_sheets/AD9850.pdf
 *
 * 16-July-2013 
 * Modified by Jim Giammanco, N5IB, to match SSNA PCB layout
 * modified by Jim Giammanco, N5IB & Jerry Haigwood, W5JH to sweep DDS and read A/D input
 * use with AD8307 as scalar network analyzer
 *
 * 09 November 2013
 * created menu and generator function (J. Haigwood, W5JH)
 *
 * 13 November 2013
 * added ADC read and display to generator function, changed generator step to floating point to allow large steps
 * zeroed out curve fit coefficients and included generic ADC counts  to dBm conversions (J. Giammanco, N5IB)
 *
 * 19 & 21 November 2013
 * corrected bugs associated with integer arithmetic. cleaned up conversion function to use global variable
 * added ADC counts display to sweep function
 * collected print operations into callable routine  (J Giammanco, N5IB)
 *
 */

// *** NOTE TO SELF AND OTHERS ON "NICK" DEFINE:  BECAUSE I USE A DIFFERENT PIN THAN D7 (MINE IS BAD)
//     IF I PROGRAM MY ARDUINO WITH NICK = 0, MY PHSNA WON'T WORK AT ALL.  AND IF
//     OTHERS PROGRAM THEIRS WITH NICK = 1, THEIR PHSNA WON'T WORK AT ALL.  THIS HAS BEEN A PUBLIC
//     (AND PRIVATE) SERVICE ANNOUNCEMENT.


#define NICK 0 // Special compile modes just for me -- set to zero for general distribution 1r10  

#if NICK
#define DATA 11        //  ***** NRK ONLY BAD PIN 8 USE 11 *******
#else
#define DATA 8        // for the rest of the world: Pin 8 - connect to serial data load pin (DATA or D7)
#endif

#define W_CLK 9       // Pin 9 - connect to AD9850 module word load clock pin (CLK)
#define FQ_UD 10      // Pin 10 - connect to freq update pin (FQ)
#define RESET 11      // Pin 11 - connect to reset pin (RST).
#define LEDpin 13     // Pin 13 - on board LED to be used as "heartbeat"
#define CH0pin 0
#define pulseHigh(pin) {digitalWrite(pin, HIGH); digitalWrite(pin, LOW); }

// clock and maximum frequency definitions depend on which DDS chip is in use
#define f_max 70e3   //set this value to 30e3 kHz (30 MHz) for AD9850, or 70e3 kHz (70 MHz) for AD9851
#define f_min 1e2    // normally 1000 kHz (1 MHz), but can be set lower - circuit values may need to be changed **
// ** WA5BDU 1r5 is trying 100 kHz as the lower limit
#define master_clk 125.000e6  //set this value to 125e6 Hz (125 MHz) for AD9850, or 180e6 Hz (180 MHz) for AD9851
// To calibrate the generator output frequency, adjust the master_clk a few hundred
// Hz either way. NRK: using f_clock for variable master reference ...
#define AREF 5.000  //anlog to digital converter reference voltage, normally about 5.0 V
#define CTRL_BYTE 0x00  // Final control byte, all 0 for 9850 chip, 0x01 for 9851

// As of 1r11, all C0 - C5 terms will be float variables, not constants ...

#define offset_dBm  0.0   // normally remains set to zero



// EEPROM memory usage:
// The funduino's ATMega328 has 1K of EEPROM (1024 bytes)

#define E_reference 0 // NRK: starts at 0, uses 0, 1, 2, 3
#define E_slope 4 // NRK plan to store slope and intercept as 2 bytes each
#define E_intercept 6 // NRK intercept takes 6 through 7 (8 is lost)
#define E_su_fq 9 // takes 9, 10, 11, 12 for long int start-up freq
#define E_mode_flag 13 // flag 0 to start in PLX (Excel spreadsheet) mode, != 0 for normal mode
#define E_loss 14 // store level measured thru shorted fixture as int, so takes 14 and 15
#define E_DDS_flag 16 // flag = 00 for AD9851 or != 00 for AD9850, single byte flag location 16
#define E_C0 17 // double (float) takes 4 bytes
#define E_C1 E_C0+4 // same - storage for curve fit polynomial values
#define E_C2 E_C1+4
#define E_C3 E_C2+4
#define E_C4 E_C3+4
#define E_C5 E_C4+4
#define E_memory E_C5+5 // E_memory will use 10*4 = 40 bytes


//Globals --- globally define several important variables
float f_low; //low frequency limit of a sweep, in Hz (entered as kHz)
float f_high;   //upper frequency limit of a sweep, in Hz (entered as kHz)
float delta_f;  //step size for sweep, in Hz
float v_dBm;  //RF power expressed in dBm after applying power meter calibration equation, but before compensation
float v_comp;  //RF power in dBm after compensating for SSNA rolloff 
float v_peak; // peak response of crystal or network in dBm
float f_temp;  //temporary value of current frequncy in MHz, needed for curve fit compensation
int CH0_ADC_counts;  //raw counts retunrd from ADC read operation, range 0 to 1023
double f_out = 7040000.;  //desired output frequency in Hz, used to calculate DDS control bytes
double f_clock = 125000000.; // NRK DDS reference frequency, can change in calibration routine
float slope; // NRK for dBm calculation
float intercept; // NRK for dBm calculation
unsigned int i_slope; // version to save to EEPROM
unsigned int i_intercept; // yep
int cal_flag; // flag is 0 if eeprom slope/int are bad, 1 if good in range check
int mode_flag; // read from EEPROM non-0 for normal mode, 0 for PLX / spreadsheet mode
int DDS_mode_flag; // read from EEPROM, 0 for AD9851 and non-o for AD9850
int rowssent; // W0FNQ -- for Excel & PLX-DAQ
char stringbuffer[80]; // for PROGMEM / PSTR

float C[6]; // C0 thru C5 are polynomial coefficients to normalize DDS over frequency range

/*float C1;
 float C2;
 float C3;
 float C4;
 float C5; */



// ***************** S E T U P() Function *********************************

void setup() {
  // configure arduino data pins for output
  //Serial.begin(9600); //set up for serial monitor at 9600 baud
  Serial.begin(19200); //set up for serial monitor at 19200 baud  // AD7JT
  Serial.setTimeout(5000);  //wait 10 sec for input, then go ahead (NRK change to 30s) (5s)
  pinMode(FQ_UD, OUTPUT);
  pinMode(W_CLK, OUTPUT);
  pinMode(DATA, OUTPUT);
  pinMode(RESET, OUTPUT);
  pinMode(LEDpin, OUTPUT);
  analogReference(EXTERNAL); // activate external 5 V reference
  pulseHigh(RESET);
  pulseHigh(W_CLK);
  pulseHigh(FQ_UD); 
  digitalWrite(LEDpin,LOW);  
}


// ********************   L O O P ( ) F U N C T I O N ****************

void loop() {

#if NICK
  Serial.println(F("\r\nThis compile specific to WA5BDU. Use #define NICK 0 for generic"));
  //  float test1;
  //	float test2;

  //	EEPROM_writeDouble(E_C2, 3.14159);
  //	EEPROM_writeDouble(E_C3, 6.023E15);

  //	Serial.println(F("Input your float: "));
  //	clear_serial_buffer();
  //	while (!Serial.available());
  //	Serial.readBytesUntil(0x0D, stringbuffer, 15);
  //	test1 = atof(stringbuffer);
  //	test1 /= 1e14;
  //	test1 = 6.023E15;
  //	test1 = Serial.parseFloat();	
  //	test1 = EEPROM_readDouble(E_C2);
  //	test2 = EEPROM_readDouble(E_C3);

  //	Serial.println();
  //	test1 /= 1e14;
  //	Serial.println(test1, 5);
  //	test2 /= 1e14;
  //	Serial.println(test2);
  //	poly();
  //	while(1);


#endif

  char choice; // rev 1r11 - choice was int, but now allow alpha and no CR required
  int i;
  double new_f_clock;


  // 1r11 - add check if all poly coefficients are 0xFF in EEPROM, if so, 
  // initialize to all 0.  If not read them into C[0] thru C[5]

  for (int i = 0; i < 24; i++)
  {

    if (EEPROM.read(E_C0+i) != 0xFF) goto skipzero;
  }

  zero_poly(); // set all to zero
skipzero:;

  get_poly_from_ee();


  // NRK - first load AD8307 calibration constants from EEPROM, if they
  // exist ...

  slope_int_from_ee();

  // 1r8: Read mode flag for AD9850 or AD9851 mode ...

  DDS_mode_flag = (int) EEPROM.read(E_DDS_flag); // non-zero for AD9850

  // 1r9 change:  Set f_clock based on DDS chip.  Then read clock from 
  // EEPROM and check that it's between 90% and 110% of default.  If so,
  // use it.  Else, stay with default.

  if(DDS_mode_flag)
  {
    f_clock = 125000000.;
  }
  else
  {
    f_clock = 180000000.;
  }


  new_f_clock = f_from_ee((int) E_reference); // read reference clock to f_clock 1r9

  if (new_f_clock > 0.9*f_clock && new_f_clock < 1.1*f_clock)
  {
    f_clock = new_f_clock;
  }

  f_out = f_from_ee((int) E_su_fq); // Read S/U frequency from EEPROM, put in f_out

  if (f_out < 50000. || f_out > 60000000.)
    f_out = 7040000; // Use if out of range


  sendFrequency(f_out); // NRK startup frequency
  say_refclock_freq(); // in calibrations.ino


  // 1r6 check desired start-up mode by reading mode flag from EEPROM


  mode_flag = EEPROM.read(E_mode_flag);

  if (mode_flag == 0)
  {
    plx_sweep();
  }

  if (mode_flag != 0)
    Serial.println(F("Mode flag: Normal Mode"));

  Serial.setTimeout(30000); // Running in terminal mode, set timeout to 30s

  say_slope_int(); // NRK 1r6 - move printing routine to *after* we know NOT PLX mode

  // NRK now tell user what frequency the DDS is on

  //     while (Serial.available() > 0) Serial.read();  // clear the Serial buffer  
  clear_serial_buffer();
  //     Serial.println(); 
  Serial.print(F("DDS: ")); //echo again 
  Serial.print(f_out, 0);
  Serial.print(" Hz  ");	

  if (DDS_mode_flag)
  {
    Serial.println(F("AD9850 mode"));
  }
  else
  {
    Serial.println(F("AD9851 mode"));
  }
  // NRK below infinite loop - always return to menu after function completes

  // At this point, we've started up in the Terminal mode.  Before proceeding, I'll
  // make one attempt at reading a cell from Excel via PLX.  If no data appears
  // after my request, I proceed with Terminal mode.  This keeps a user with no
  // terminal program from getting stuck in terminal mode ...  Also, if I DO get
  // data back from Excel, I'll change the mode byte to PLX mode

  // Note below:  Didn't work until I waited 100 ms before checking !!!!!

  if(mode_flag != 0)
  {
    clear_serial_buffer();
    Serial.println("CELL,GET,L2"); // Should hold lower limit for sweep
    delay(100); // If there's no response in 100 ms (!), I move on ...///adjt - changed to 200ms
    if (Serial.available())
    {
      i = Serial.parseInt(); // throw away content, don't care what's there
      EEPROM.write(E_mode_flag, 0); // 0 for PLX mode
      Serial.println(F("MSG,Mode changed to PLX/Excel"));
      delay(4000);
      plx_sweep();
    }

  }
  Serial.println(F("PHSNA Standard rev 3.02"));

  do {
    choice = 'x'; // start needing valid choice
    Serial.println(); //send CR+LF

    //    while (Serial.available() > 0) Serial.read();  // clear the serial buffer
    Serial.println();
    Serial.println(F("Select:\r\n"));
    //    Serial.println(F("   0 - Restore this menu screen"));//////AD7JT
    //    Serial.println(F("   1 - SNA Functions"));/////////////////AD7JT
    //    Serial.println(F("   2 - Generator Functions")); //////////AD7JT
    //    Serial.println(F("   3 - Return Loss Bridge & SWR")); /////AD7JT
    //    Serial.println(F("   4 - Measure Crystal Parameters"));////AD7JT
    //    Serial.println(F("   5 - Memories"));//////////////////////AD7JT
    //    Serial.println(F("   6 - Scan"));  ////////////////////////AD7JT
    //    Serial.println(F("   * - Options & Calibrations Menu"));///AD7JT

    Serial.println(F("0 - Restore this menu screen"));///////////AD7JT
    Serial.println(F("1 - SNA Functions"));//////////////////////AD7JT
    Serial.println(F("2 - Generator Functions")); ///////////////AD7JT
    Serial.println(F("3 - Return Loss Bridge & SWR")); //////////AD7JT
    Serial.println(F("4 - Measure Xtal Parameters"));////////////AD7JT
    Serial.println(F("5 - Memories"));///////////////////////////AD7JT
    Serial.println(F("6 - Scan"));  /////////////////////////////AD7JT
    Serial.println(F("* - Options & Calibrations"));/////////////AD7JT

    Serial.println();


    Serial.print(F("Choice: "));     
    clear_serial_buffer();

    while (!Serial.available());
    choice = toupper(Serial.read()); 

    switch(choice)
    {
    case '1':
      sweep(); // in SNA.ino file
      break;

    case '2':
      generator(); // in generator.ino file
      break;

    case '3':
      RLB(); // in RLB.ino file
      break;

    case '4': // Sweep crystal and calculate parameters WA5BDU 1r7
      sweep_xtal(); // in the crystal.ino file
      break;

    case '5': // Frequency memories in EEPROM save, recall, etc.
      memories(); // in the misc_functions.ino file
      break;

    case '6': // Frequency memories in EEPROM save, recall, etc.
      scan(); // in the misc_functions.ino file
      break;

    case '*': // Go to Options & Calibrations sub-menu
      options();  // it's in the misc_functions.ino file
      break;	

    case '0': // Case to re-print menu
      more_menu(); // calls routine that just returns, to re-do menu on 9
      break;

    default:
      break;
    }     

  }  
  while (1); // main menu infinite DO loop

}  






