// Part of PHSNA project.  These functions by Nick, WA5BDU
// Rev 1r9 made this file separate

//  ***** SET START-UP FREQUENCY TO USER DEFINED ********

void say_set_func(){
  Serial.println(F("\xC0\r  SETTING STARTUP FREQUENCY\r")); //send CR+LF
}

void say_quit(){
  Serial.print(F("X any other key to quit\r "));
}

void set_startup_fq()
{
  char choice;
  long i_f_out;

  say_set_func();
  say_enter_freq();
  clear_serial_buffer();
  f_out = Serial.parseFloat();
  Serial.println(f_out,0);
  sendFrequency(f_out);
  Serial.println(F("\rPress:\r"));
  Serial.println(F("Y to write to EEPROM\r "));
  say_quit();
  while((choice = get_char()) == 0x0d);
  if (choice != 'Y'){
    Serial.println(F("EXITING WITH NO CHANGE"));
  }else{
    i_f_out = (int32_t) f_out; // set to new frequency now
    for (int i=E_su_fq; i<(E_su_fq + 4); i++){
      EEPROM.write(i, (byte) i_f_out & 0xFF);
      i_f_out >>= 8; // shift 1 byte to right
    }
    Serial.println(F("EEPROM UPDATED"));
  }
  delay(2000);
}

// *****  SET START-UP MODE TO PLX OR NORMAL TERMINAL MODE

void set_startup_mode(){
  char choice;

  say_set_func();
                      //012345678901234567890123456789
  Serial.println(F("PLX mode expects to interface"));
  Serial.println(F("with NAT in PLX mode.  Normal"));
  Serial.println(F("mode expects to interact in"));
  Serial.println(F("Terminal mode with menus."));
  say_press();
  Serial.println(F("P for PLX mod\r "));
  Serial.println(F("N for Normal mode\r "));
  say_quit();
  while((choice = get_char()) == 0x0d);
//  clear_serial_buffer();
//  while (!Serial.available());
//  choice = toupper(Serial.read());
  if (choice == 'P'){ 
    EEPROM.write(E_mode_flag, 0); // 0 for PLX mode
    Serial.println(F("Switched to PLX mode"));
  }else if (choice == 'N'){
    EEPROM.write(E_mode_flag, 1); // NOT 0 for "normal" mode
    Serial.println(F("Switched to normal mode"));
  }else{
    Serial.println(F("EXITING WITH NO CHANGE"));
  }
  delay(2000);
}

// *************** TOGGLE AD9850 / AD9851 MODES ********************

void toggle_DDS_mode(){
  char choice;
                      //  012345678901234567890123456789
  Serial.println(F("\xC0\r     TOGGLE AD9850/51 MODE\r")); //send CR+LF
  Serial.print(F("\rCurrent mode: "));
  if (DDS_mode_flag){
    Serial.println(F("AD9850"));
  }else{
    Serial.println(F("AD9851"));
  }
  say_press();
  Serial.println(F("Y to change\r "));
  say_quit();
  while((choice = get_char()) == 0x0d);
//  clear_serial_buffer();
//  while(!Serial.available());
//  choice = toupper(Serial.read());
  if(choice == 'Y'){
    DDS_mode_flag = DDS_mode_flag ? 0 : 1;
    EEPROM.write(E_DDS_flag, (byte)DDS_mode_flag); 
    Serial.println(F("RESET ARDUINO TO TAKE EFFECT"));
  }else{
    Serial.println(F("EXITING WITH NO CHANGE"));
  }
  delay(4000);
}


