// rev. WA5BDU 1r9 moved to separate file

void say_escape(){
  Serial.println(F("\x1B - Escape to quit\r "));
}



// **********  CLEAR SERIAL BUFFER ******************************************
// Below addresses a problem I had when using a routine that did the same as this
// but without the time delay.  It occurred when the sender was in process of
// sending a string of characters.  The routine would read one character and then
// check Serial.available() and find it was 0, because the next character hadn't 
// been fully shifted in yet.  At 9600 baud, a character takes 1.04 ms to transmit.
// I'll conservatively wait 10 ms after getting a byte before checking for another
// char available.  NRK 12/10/2013

void clear_serial_buffer(){
  while (Serial.available() > 0){
    delay(10);
    Serial.read();  // get available byte
  }
}

// Print a comma and a space with no linefeed ...

void comma_space(){
  Serial.print(", ");
}
// Print a backspace character

void backspace(){
  Serial.print("\b");
}

void print_8_stars(){
  Serial.println(F("********"));
}

void say_enter_freq(){
  Serial.println(F("Enter frequency in Hz:"));
}

// ******************  GET A SINGLE CHARACTER FROM SERIAL PORT **********************

char get_char(){
  delay(100);
  clear_serial_buffer(); // clear out old trash
  while (!Serial.available()); // wait until a char is ready
  return (toupper(Serial.read()));
}

// *****************  TRANSFER PHASE INCREMENT DATA TO DDS CHIP ************************

// transfers a byte, a bit at a time, LSB first to the 9850/9851 via serial DATA line
// In the "for()" statement below, a discussion broke out on PHSNA group about the 
// meaning of "data>>=1" and if the = is necessary.  It *is* necessary, to assign the
// result of the right shift back to data.

void tfr_byte(byte data){
  for (int i=0; i<8; i++, data>>=1){
    digitalWrite(DATA, data & 0x01);
    pulseHigh(W_CLK);   //after each bit sent, CLK is pulsed high
  }
}


// **********************   CALCULATE PHASE INCREMENT AND SEND TO DDS ************************

// 1r11 renaming "freq" as "delta_phase" for clarity

// frequency calc from datasheet page 8 = <sys clock> * <frequency tuning word>/2^32

void sendFrequency(double frequency){
  unsigned long delta_phase = frequency * 4294967295/f_clock; 
  f_out = frequency; // NRK 1r7 - f_out used in dBm frequency comp, so make sure it always = frequency
  int ctrl_adder = 0;  // add to control byte.  If AD9851 mode, set = 1

  // delta_phase = 167980943UL; // for testing, this is phase incr for 7.040 Mhz and 180 MHz clock

  for (int b=0; b<4; b++, delta_phase>>=8) {
    tfr_byte((byte)(delta_phase & 0xFF));
  }
  if(!DDS_mode_flag) ctrl_adder = 1; // 1r8
  tfr_byte(CTRL_BYTE + ctrl_adder); // 1r8
  pulseHigh(FQ_UD);  // Done!  Should see output
}



//*******************************USER MUST EDIT THE SLOPE AND INTERCEPT VALUES TO CALIBRATE AD8307*********************
// ****************************     OR USE BUILT-IN SLOPE / INTERCEPT CALC AND STORE TO EEPROM    ********

// conversion of ADC counts to dBm
float counts_to_dBm() {
  // Power Meter Calibration - Conversion of ADC counts to dBm                
  // the equations below convert the raw output (pin 4) of the AD8307 to dBm
  // for a raw, unamplified AD8307:
  // assuming 0.025 V per dBm, and 0 V corresponds to -84 dBm, so 0 dBm is 2.1 V, and +10 dBm is 2.35V
  //
  // but most 8307 meters would have a buffer amp with some gain so that +10 dBm will be about 5 V
  // to accomodate that amplifier the parameters below would have to be recalculated... think y = mx + b
  // you have to determine the slope in dBm per volt (e.eg. 18.8)
  // and the intercept in dBm correcponding to zero volts, e.g. -84
  // 
  //v_dBm = -84 + ((40*CH0_ADC_counts)/1023.0)*AREF; // generic transfer function for raw, unamplified AD8307 output
  if (!cal_flag){
    v_dBm = -84 + ((18.8*CH0_ADC_counts)/1023.0)*AREF; 
  }else{
    v_dBm = intercept + slope * CH0_ADC_counts; // NRK - use eeprom values unless out of range, then use default
  }
  // starting point, generic transfer function for amplified AD8307, 
  //                                        where 5 V <=> +10 dBm, and -84 dBm <=> 0 V
  //v_dBm = -84 + (0.0918866)*CH0_ADC_counts;     // alternate form using only ADC counts
  //                                       where 1023 counts <=> +10 dBm, and 0 counts <=> -84 dBm 

  //v_dBm = -84.28 + ((16.92*CH0_ADC_counts)/1023.0)*AREF; //example of Jerry's dBm conversion
  //v_dBm = -85.24 + ((16.28*CH0_ADC_counts)/1023.0)*AREF; // example of Jim's dBm conversion
  //v_dBm = -85 + (0.07935)*CH0_ADC_counts;  // alternate form of Jim's dBm conversion that needs only ADC counts

  f_temp=f_out/1e6;       
  v_comp = (C[0] + f_temp * (C[1] + f_temp * (C[2] + f_temp * (C[3] + f_temp * (C[4] + f_temp*C[5]))))); // NRK change 1r6
  return (offset_dBm + v_dBm - v_comp);
}


// Below "do nothing" function returns to main menu from case stmt
void more_menu(){ 
  return;
} // Called when user hits invalid menu choice, to repeat menu


// *********************  MEMORIES **********************************************

//     Memories routines written by wA5BDU 1/24/2014 1r11 
// *** Note that "empty" memories will contain four bytes of 0xFF ***


void memories(){
  int valid_choice;
  do {
    Serial.println(F("\xC0\r       MEMORY FUNCTIONS\r")); //send CR+LF
    list_mems();
    char choice;
    Serial.println(F("\r Select 0-9 to set frequency\r "));
    Serial.println(F("P to program a memory\r "));
    Serial.println(F("C to clear a memory\r "));
    say_escape();
    while((choice = get_char()) == 0x0d);
    valid_choice = 1;
    switch(choice){
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        Serial.write(choice);
        Serial.print(": ");
        if (!mem_is_empty(choice)){
          go_to_freq(choice);			
          Serial.println(f_out);
        }else{
          print_8_stars();
        }
        break;
      case 'P':
        program_memory();
        break;
      case 'C':
        clear_memory();
        break;
      case 0x1B:
        return;
        break;
      default:
        valid_choice = 0;
        break;
    }
  }while(valid_choice);
}

//  ****   GO TO MEMORY FREQUENCY ****

void go_to_freq(char choice)
{
  int index = choice - '0';
  f_out = f_from_ee((int)(index*4 + E_memory));
  sendFrequency(f_out);
}

// ****  SEE IF MEMORY CHANNEL IS EMPTY ***

int mem_is_empty(char choice){
  // Note, choice is an ASCII char 0 thru 9, not a number

  int r_value = 1; // 1 means memory is empty
  for (int i = 0; i < 4; i++){
    if (EEPROM.read(E_memory + 4*(choice-'0') +i) != 0xFF) r_value = 0;
  }
  return r_value;
}

// ****** LIST ALL MEMORY CONTENTS **********

void list_mems(){
  float local_freq;

  for (int i = 0; i <= 9; i++){
    Serial.write(i + '0');
    Serial.print(": ");
    if (!mem_is_empty((char)(i+0x30))){
      local_freq = f_from_ee((int)(i*4 + E_memory));
      Serial.println(local_freq,0);
    }else{
      print_8_stars();
    }
  }
}

// ****  PROGRAM A MEMORY WITH USER SPECIFIED FREQUENCY *****

void program_memory(){
  float f_mem;
  char choice;
  Serial.print(F("\rMem #: "));
  while((choice = get_char()) == 0x0d);
  if (!(choice >= '0' && choice <= '9')) goto goodbye; 
  Serial.println(choice);
  say_enter_freq(); // ask for frequency entry
  get_to_sb(); // get frequency to stringbuffer
  f_mem = atof(stringbuffer); // convert it to float
  f_to_ee(f_mem, E_memory + 4*((int)(choice-'0')));

goodbye:;
}

// ***********  CLEAR A MEMORY CHANNEL IN EEPROM *******************************

void clear_memory(){
  char choice;
  int index;
  Serial.print(F("\rMem #: "));
  while((choice = get_char()) == 0x0d);
  if (!(choice >= '0' && choice <= '9')) goto goodbye;
  index = (int)(4*(choice - '0')) + (int) E_memory;
  for (int i = index; i < index+4; i++){
    EEPROM.write(i, 0xFF);
  }
  Serial.println(F("Cleared!\r\n"));
goodbye:;
}

// **********  SCAN A FREQUENCY RANGE *******************************************

// *** Start 11/25/14, WA5BDU *** Finished 01/25/2014

void say_scan_func(void){
  Serial.println(F("\xC0\r    SCAN A FREQUENCY RANGE\r"));
}

void scan()
{
  char choice;
  float low_freq;
  float high_freq;
  float freq_now;
  float step;
  int t_delay;
  
//  Serial.println(F("\xC0\r    SCAN A FREQUENCY RANGE\r"));
  say_scan_func();
  say_get_low();
  low_freq = 1000. * get_freq(3);
  say_get_high();
  high_freq = 1000. * get_freq(3);
  say_get_step();
  step = get_freq(0);
  say_get_delay();
  t_delay = (int) get_freq(0);
  freq_now = low_freq;
  say_scan_params(low_freq, high_freq, step, t_delay, 0);
  clear_serial_buffer();
  do{
    sendFrequency(freq_now);
    delay(t_delay);
    freq_now += step;
    if (freq_now > high_freq) freq_now = low_freq;
    if (Serial.available()){
      choice = toupper(get_char());
 //     if((choice = toupper(get_char())) == 0x0d){
 //       ;  // ignore leading CR
 //     }else{
        Serial.print(F("\rchoice: "));
        Serial.println(choice);
 //       Serial.println();
        switch (choice){
          case 0x0d:
            break;  // ignore leading/trailing CR
          case 'L':
            say_get_low();
            low_freq = 1000. * get_freq(3);
            break;
          case 'H':
            say_get_high();
            high_freq = 1000. * get_freq(3);
            break;
          case 'S':
            say_get_step();
            step = get_freq(0);
            break;
          case 'D':
            say_get_delay();
            t_delay = (int) get_freq(0);
            break;
          case 'P':
            say_scan_params(low_freq, high_freq, step, t_delay, 1);
            Serial.print(F("Freq: "));
            Serial.print(freq_now - step,0);
            get_char();
            break;
          default:
            goto theend;
        }
        say_scan_params(low_freq, high_freq, step, t_delay, 0);
//      }
    }
   }while(1);
theend:;
}
// ***********  GET FREQUENCY (OR ANY FLOATING POINT #) ****************

float get_freq(int scale){
  float local_mem;
  get_to_sb(); // get frequency to stringbuffer
  local_mem = atof(stringbuffer);
  Serial.println(local_mem, scale);
  return (local_mem);
}

void say_get_low(){
  Serial.println(F("\rEnter FREQ LO in kHz:"));
}

void say_get_high(){
  Serial.println(F("\rEnter FREQ HI in kHz: "));
}

void say_get_step(){
  Serial.println(F("\rEnter FREQ ST Hz: "));
}

void say_get_delay(){
  Serial.println(F("\rEnter delay/step  in ms:"));
}

// **************  PRINT SCAN PARAMETERS ******************

void say_scan_params(float lo, float hi, float step, int delay, int paused)
{
  say_scan_func();
  if(paused){
    Serial.println(F("            PAUSED"));
  }else{
    Serial.println(F("           SCANNING"));
  }
  say_press();
  Serial.print(F("L(ow) : "));
  Serial.println(lo,0);
  Serial.print(F(" \rH(igh): "));
  Serial.println(hi,0);
  Serial.print(F(" \rS(tep): "));
  Serial.println(step,0);
  Serial.print(F(" \rD(elay): "));
  Serial.println(delay);
  Serial.println(F(" \rP to pause/resume\r "));
  say_quit();
}


// ******************  "About PHSNA" Menu Option *********************************

void about()
{
  say_version();
  Serial.println(F("\r Simple SNA by: \r  Jim Giammanco, N5IB\r  Jerry Haigwood, W5JH\r  Nick Kennedy, WA5BDU\r"));
//  Serial.println(F(" Additional programming by:\r  Nick Kennedy, WA5BDU\r"));
  Serial.println(F(" Discussion group & files:\r  https://groups.yahoo.com/\r  neo/groups/PHSNA/info\r"));
  Serial.println(F(" NAT adaptation by:\r  Dave Collins, AD7JT\r"));
  say_quit();
}


// ***************  OPTIONS & CALIBRATIONS SUB-MENU *****************************


void options(){
  char choice;
  do{
     //                     012345678901234567890123456789
    Serial.println(F("\xC0\r * * O P T I O N  M E N U * *\r"));
    Serial.println(F("A - AD8307 slope / intercept\r "));
    Serial.println(F("C - Curve fit poly constants\r "));
    Serial.println(F("D - DDS reference frequency\r "));
    Serial.println(F("P - Toggle PLX (Excel) mode\r "));
    Serial.println(F("S - Set Start-Up Frequency\r "));
    Serial.println(F("M - Toggle AD9850/51 modes\r "));
    Serial.println(F("Q - About PHSNA\r "));
    Serial.println(F("$ - Re-display menu\r "));
    Serial.println(F("^ - Back to main menu\r "));

    choice = 0;
 //   Serial.println(F("\rOPTION Menu Selection:"));
    clear_serial_buffer();
    while (!Serial.available());
    choice = toupper(Serial.read()); 
    switch(choice){
      case 'A': 
        constants(); 
        break;
      case 'S': // Set start-up frequency
        set_startup_fq();
        break;
      case 'P': // Change mode to PLX WA5BDU 1r6
        set_startup_mode();
        break;
      case 'M': // Toggle AD9850 / AD9851 modes 1r8
        toggle_DDS_mode();
        break;
      case 'C': // Enter Curve Fit Polynomial constants
        poly(); // located in eeprom_i_o.ino
        break;
      case 'Q': // Credits and website information
        about(); // in this file
        clear_serial_buffer();
        while (!Serial.available());
        break;
      case 'D': // Credits and website information
        calibrate(); // in calibrations.ino
        break;
      case 0x1b:					  
      case '^': // Return to main menu
        goto exit;
        break; // This break actually not needed  
      case '$':
        break;
    }
  } 
  while(1); // Loop forever unless goto exit: occurs ...
exit:;
}


