// perform the generator function

void say_gen_func(){
  Serial.println(F("\xC0\r   GENERATOR FUNCTIONS\r"));
}

void generator(){
  char ac;
  int update = 0; // continuously update dBm if update <> 0
//  Serial.println(F("\xC0\r   GENERATOR FUNCTIONS\r")); //send CR+LF
  say_gen_func();

  do {
    Serial.println(F("Enter frequency in kHz: "));
    clear_serial_buffer();
    while (Serial.available() == 0) ;  // wait for some input
    while (Serial.peek() != 0x0D) {
      f_out = Serial.parseFloat();
    }
  }while (f_out < f_min || f_out > f_max);  // 1000 KHz lower limit
  Serial.println(f_out,3);

  do{
    Serial.println(F("\rEnter FREQ ST size in Hz: "));
    clear_serial_buffer();
    while (Serial.available() == 0) ;  // wait for some input
    while (Serial.peek() != 0x0d) {
      delta_f = Serial.parseFloat();
    };
  }while(delta_f < 1.0); 
  Serial.println(delta_f);   // display step size

  f_out *= 1000.0;
  sendFrequency(f_out);  // freq

  do{
    generator_displayLine();
    say_press();
    Serial.println(F("8 to increase freq.\r "));
    Serial.println(F("2 to decrease freq.\r "));
    Serial.println(F("\r4 for frequency step/2\r "));
    Serial.println(F("6 for frequency stepx2\r "));
    Serial.println(F("Enter for dBm update\r "));
    Serial.println(F("U for continous dBm updates\r "));
    Serial.println(F("Q to quit"));
    while((ac = get_char()) == 0x0d);
    switch(ac){
      case '2':
        if (f_out - delta_f >= f_min*1000) {  //f_min is defined in kHz
          f_out = f_out - delta_f;
          sendFrequency(f_out);  // freq
          delay(10);
        }
        break;
      case '8':
        if (f_out + delta_f <= f_max*1000){    //f_max is defined in kHz
          f_out = f_out + delta_f;
          sendFrequency(f_out);  // freq
          delay(10);
        }
        break;
      case '4':
        if (delta_f > 1){
          delta_f = delta_f/2;
        }    
        Serial.println();
        Serial.print(F("Step Size is: "));
        Serial.print(delta_f);
        Serial.println(F(" Hz"));
        break;
      case '6':
        if ((delta_f * 2) <= (f_max*1000 - 1e6)) {   //f_max is define in kHz      
          delta_f = delta_f * 2;
        }    
        Serial.println(); 
        Serial.print(F("Step Size is: "));
        Serial.print(delta_f);
        Serial.println(F(" Hz"));
        break;
      case 'U':
        Serial.println(); 
        Serial.println(F("Continuous update ... "));
        update = 0xff;
        do_update_dBm();
        break;
      default:
        break;
    }
  }while(ac != 'Q');

}

void generator_displayLine()  {
  say_gen_func();
  Serial.print("Step size is: ");
  Serial.print(delta_f);   // display step size
  Serial.println(" Hz");
  
  Serial.print(F("\rFrequency is: "));
  Serial.print(f_out/1000.,3);  // show new frequency in kHz 1r9 show to 1 Hz
  Serial.println(F(" kHz"));
  
  Serial.print(F("ADC counts = "));
  CH0_ADC_counts = analogRead(CH0pin);
  Serial.print(CH0_ADC_counts);
  Serial.print(", ");
  Serial.print(counts_to_dBm());
  Serial.println(F("  dBm"));
}
// for revision 1r9 (below), function to update dBm reading continuously

void do_update_dBm(){
  int old_counts = 0;
  Serial.println();
  clear_serial_buffer();
  do{
    delay(250); // update four times per second	
    CH0_ADC_counts = analogRead(CH0pin);
    if(old_counts != CH0_ADC_counts){
      old_counts = CH0_ADC_counts; // update if changed
      Serial.print(counts_to_dBm(),1);
      Serial.println(F(" dBm  "));
    }
  }while (!Serial.available()); // Continue until user hits a key
}





