// Routines to find / calculate crystal parameters.

// by Nick Kennedy, WA5BDU

// ***********************  FIND PEAK ****************************************


// Alters globals f_low and f_high and v_peak
// Returns f_peak and puts peak dBm in v_peak

float find_peak()
{
  int width = 1; // width of peak in # of delta_fs
  f_low *= 1000.;
  f_high *= 1000.;
  v_peak = -85.; // initialize to minimum value
  float temp_dBm;
  float f_peak; // freq where peak occurred

  sendFrequency(f_low); // clear the breach (below)

  for (int i = 3; i > 0; i--)
  {

    CH0_ADC_counts = analogRead(CH0pin); // throw away some reads
    delay (50);
  }
  while (f_low <= f_high)
  {
    sendFrequency(f_low);
    delay(2);
    CH0_ADC_counts = analogRead(CH0pin);   //read the ADC
    temp_dBm = counts_to_dBm();

    if (temp_dBm >= v_peak) 
    {
      f_peak = f_low;
      if (temp_dBm == v_peak) width++; // found a peak point
      if (temp_dBm > v_peak) width = 1; // reset for new, higher peak
      v_peak = temp_dBm;			  
    }
    f_low += delta_f;
  }
  f_peak = f_peak - (delta_f * (float) width / 2.); 
  return (f_peak);
}  

// *****************  FIND -3dB POINTS  -BANDWIDTH- **********************


// The peak frequency is passed as the argument and the peak response is
// stored in global variable v_peak.  This function scans down, then up from
// the peak to find the -3dB points and bandwidth.  It returns the bandwidth
// Assume calling program set global delta_f = 1.0

float get_bw(float f_peak)
{
  int width = 0;
  float temp_dBm;
  float low_freq;
  float high_freq;
  float low_level;
  float test_freq;
  int count_l;
  int count_h;


  test_freq = f_peak; // f_peak should be in Hertz

  low_level = -100.;
  sendFrequency(test_freq); // warm up
  delay(10);
  analogRead(CH0pin); // 3r01 mystery bug ... read, throw away ...
  count_l = 2500;
  do
  {
    count_l--;
    if (!count_l) break;  
    test_freq -= delta_f;
    sendFrequency(test_freq);
    delay(10); // try some delay for mystery problem 3r01 - previously 5 ms
    CH0_ADC_counts = analogRead(CH0pin);
    temp_dBm = counts_to_dBm();

    if ((temp_dBm <= v_peak - 3.) && !width)
    {
      low_level = temp_dBm; // first finding of <= -3 dBm point
      low_freq = test_freq; // these statements execute only once
    }
    if (temp_dBm == low_level) width++; // if multiple points at same level, count them
  } 
  while (temp_dBm >= low_level); // quit when below first <= -3 dB point
  low_freq -= delta_f * (width-1.)/2.0; // 3r01 width = 1 is just a single point, so no adder
  //	 Serial.print(F("Low -3 dB  freq:  "));
  //     Serial.println(low_freq, 0);
  //	 Serial.print(F("Peak freq: "));
  //	 Serial.println(f_peak,0);
  //	 Serial.print("  dBm = ");
  //	 Serial.print(low_level, 2);
  //  Finished finding low frequency -3dB point, now do high point

  test_freq = f_peak;
  width = 0;
  low_level = -100.;
  sendFrequency(test_freq); // warm up
  delay(5);
  count_h = 2500;
  do
  {
    count_h--;
    if (!count_h) break;
    test_freq += delta_f;
    sendFrequency(test_freq);
    delay(2); // delay again for mystery problem
    CH0_ADC_counts = analogRead(CH0pin);
    temp_dBm = counts_to_dBm();

    if ((temp_dBm <= v_peak - 3.) && !width)
    {
      low_level = temp_dBm; // first finding of <= -3 dBm point
      high_freq = test_freq;
    }
    if (temp_dBm == low_level) width++; // if multiple points at same level, count them
  } 
  while (temp_dBm >= low_level); // quit when below first <= -3 dB point
  high_freq += delta_f * (width-1.)/2.0;	// 3r01 made width be (width-1.)	
  //	 Serial.print("High -3 dB freq:  "); //echo again 
  //   Serial.println(high_freq, 0);
  //	 Serial.print("  dBm = ");
  //	 Serial.print(low_level, 2);
  if (!count_l || !count_h){
    Serial.println(F("\r\n>2500 steps with -3dB not found!"));
    delay(2000);
  }
  return(high_freq - low_freq);
}

// ******************  GET & SAVE MEASUREMENT FIXTURE LOSS ******************

//   Actually, we're getting dBm level with shorted fixture installed
//  
float get_loss(){
  float temp_dBm;

  Serial.println(F("Enter test frequency, kHz: "));
  clear_serial_buffer();
  while (Serial.available() == 0);  // wait for some input
  while (Serial.peek() != 0x0D) {
    f_low = Serial.parseFloat();
  }
  Serial.println(f_low,3);
  f_low *= 1000;
  sendFrequency(f_low); 
  Serial.print(F("\rX - Short fix., press any key\r "));
  clear_serial_buffer();
  while(Serial.available()==0);
  // Now warm up the ADC
  for (int i = 3; i > 0; i--){
    CH0_ADC_counts = analogRead(CH0pin); // throw away some reads
    delay (50);
  }	
  CH0_ADC_counts = analogRead(CH0pin);
  temp_dBm = counts_to_dBm();
  return(temp_dBm);
}


// *************   SWEEP CRYSTAL & CALCULATE PARAMETERS   ********************
char xtal_name[11] = "XTAL"; // allow 10 chars for name

void sweep_xtal(){
  char choice;
  float f_peak;
  float bw; // 3 dB bandwidth of crystal / resonator
  float ohms; // crystal fixture terminations
  float short_db; // level thru fixture while shorted
  float r_series; // Rs value of the crystal
  float cm; // Cm value of the crystal
  float lm; // Lm of crystal
  float q; // Q of the crystal
  float f_low_local;
  float f_hi_local;
  int flag = 0; // When set will mean some parameters already entered

  short_db = loss_from_ee(); // read from eeprom, range check below
  if (short_db < -42.5 || short_db > 22.5)
    short_db = 0.0;
  Serial.println(F("\xC0\r      CRYSTAL FUNCTIONS\r")); //send CR+LF
  do{
    Serial.print(F("Current Xtal ID: "));
    Serial.println(xtal_name);
    say_press();
    Serial.println(F("Y - to assign/change xtal ID\r "));
    Serial.println(F("N - leave xtal ID unchanged\r "));
    while((choice = get_char()) == 0x0d);
    if(choice == 'Y'){
      for (int i = 0; i < 11; i++) xtal_name[i] = '\0';
      Serial.println(F("\rCrystal ID (10 char max):")); // 1r10
      clear_serial_buffer();
      Serial.readBytesUntil(0x0D, xtal_name, 10);
      Serial.print(F("New Crystal ID: "));
      Serial.println(xtal_name);
    }
    if (!flag){
      say_press();
      Serial.println(F("M to meas. shorted fixture\r "));
      Serial.println(F("X or any other key to not\r "));
      Serial.print(short_db,2);
      Serial.println(F(" dBm\r "));

      while((choice = get_char()) == 0x0d);
      if(choice == 'M'){
        short_db = get_loss();
        Serial.print(F("\rShorted level: "));
        Serial.print(short_db,2);
        Serial.println(F(" dBm"));
        // Now give user choice to save reading to EEPROM:
        say_press();
        Serial.println(F("Y to save to EEPROM\r "));
        Serial.println(F("X or any other key to not\r "));
        while((choice = get_char()) == 0x0d);
        if(choice == 'Y') loss_to_ee(short_db);
        Serial.println(F("\rNow install crystal ..."));
      }

      if(!flag){
        Serial.println(F("\rEnter fixture term resistance"));
        Serial.println (F("usuually 50 or 12.5 ohms):"));
        clear_serial_buffer();
        ohms = Serial.parseFloat();
        Serial.println(ohms);
      }		
      do{
        Serial.println(F("\rEnter FREQ LO in kHz: "));
        clear_serial_buffer();
        while(Serial.available() == 0);  // wait for some input
        while (Serial.peek() != 0x0D) {
          f_low = Serial.parseFloat();
        }
      }while (f_low < f_min || f_low > f_max);  // 1000 kHz lower limit
      f_low_local = f_low; // save for re-run
      Serial.println(f_low,3);
      
      do{
        Serial.println(F("\rEnter FREQ HI in kHz"));
        clear_serial_buffer();
        while (Serial.available() == 0) ;  // wait for some input
        while (Serial.peek() != 0x0D) {
          f_high = Serial.parseFloat();
        }
      }while ((f_high <= f_low) || (f_high > f_max));  // f_high has to be > f_low.  
      f_hi_local = f_high;
      Serial.println(f_high,3);
    }
    delta_f = 1.0;	  
    f_low = f_low_local; // in case this is a repeat run
    f_high = f_hi_local; 
    Serial.println();
    Serial.println(F("ID#, F_peak, loss (dB), BW,"));
    Serial.println(F("Rs, Cm (pF), Lm (mH), \rQ\r"));
    f_peak = find_peak(); // returns peak freq and puts peak level to v_peak (global)
    Serial.print(xtal_name);
    comma_space();
    Serial.print(f_peak, 0);
    comma_space();
    Serial.print(short_db - v_peak, 2);	 
    comma_space();
    bw = get_bw(f_peak); // finds high and low -3 dB points and returns bandwidth
    Serial.println(bw, 1);

    // Now I have information needed to calculate some parameters.  
    // Rs = 2*Rg*[10^(alpha/20) - 1] where Rg is source & load R and alpha is
    // crystal loss at resonance
    r_series = 2.0 * ohms*(pow(10, (short_db - v_peak)/20.) -1);
    Serial.print(r_series,1);
    comma_space();
    // Now calculate Cm which is = bw /(2*PI*f1*f2*(Rs+2*Rg)), where
    // BW is f1 - f2 (3 dB points) and f1 * f2 is ~= fres^2
    cm = bw / (6.2832 * (2.0*ohms+r_series) * pow(f_peak, 2.0));
    Serial.print(1e12*cm, 7);
    comma_space();

    // Calculate Lm:
    lm = 1.0/(39.47842 * pow(f_peak, 2.0) * cm); // constant term is 4 * Pi^2
    Serial.print(1e3*lm, 6);
    comma_space();
    Serial.println();
    // Now do Q just as the reactance of Lm (or Cm) at resonance divided by Rs
    q = 6.2832 * f_peak * lm / r_series;
    Serial.println(q, 0);
    flag = 1; // flag that parameters have been set once
    say_press();
    Serial.println(F("Y to test another\r "));
    Serial.println(F("X to return to menu\r "));
    clear_serial_buffer();
    while (!Serial.available());
  } 
  while (toupper(Serial.peek()) == 'Y');
}


// *************************************************************************


