// Add calibration routine to adjust reference frequency and save it to EEPROM (below)
// by Nick Kennedy, WA5BDU

void say_dds_func(){
  Serial.println(F("\xC0\r      DDS REFERENCE FREQ\r")); 
}

void calibrate() {
  say_refclock_freq();
  char choice = 'X';
  say_dds_func();
  Serial.print(F("\r\nRef clock freq: ")); 
  Serial.println(f_clock,0);

  Serial.println(F("\rDetermines DDS ref freq"));
  Serial.println(F("and stores it in EEPROM"));
  Serial.println(F("You adjust the DDS until you"));
  Serial.println(F("measure 10.000 MHz on your"));
  Serial.println(F("counter or standard."));
  say_press();
  Serial.println(F("Y to continue\r "));
  say_quit();
  while((choice = get_char()) == 0x0d);
  if(choice != 'Y'){
    Serial.println(F("Function cancelled"));
    delay(4000);
    return;
  }
  
  // Now we really want to do the calibration.  Set frequency to 10.000 MHz

  f_out = 10000000;
  sendFrequency(f_out);

  while(1){
    say_dds_func();
    Serial.print(F("Ref clock freq: ")); 
    Serial.println(f_clock,0);
    say_press();
    Serial.println(F("6 to raise frequency   1 Hz\r "));
    Serial.println(F("7 to raise frequency  25 Hz\r "));
    Serial.println(F("8 to raise frequency 100 Hz\r "));
    Serial.println(F("5 to lower frequency   1 HZ\r "));
    Serial.println(F("4 to lower frequency  25 Hz\r "));
    Serial.println(F("3 to lower frequency 100 Hz\r "));
    Serial.println(F("W to save new frequency\r "));
    say_quit();
    while((choice = get_char()) == 0x0d);
    switch (choice){
      case '6':
        f_clock += 1;
        break;
      case '7':
        f_clock +=25;
        break;
      case '8':
        f_clock +=100;
        break;           
      case '5':
        f_clock -= 1;
        break;
      case '4':
        f_clock -= 25;
        break;
      case '3':
        f_clock -=100;
        break;
      case 'W':        
        f_to_ee(f_clock, E_reference);
        Serial.println(F("SAVE AND EXIT"));
        return;
        break;
      default:
        Serial.println(F("EXITING WITOUT SAVING"));
        delay(2000);
        return;
        break;
    }
    sendFrequency(f_out); // update with new reference clock value
  }

//  // Here user's choice was C (cancel) or W (write)
//
//  if (choice == 'W')
//  {
//    f_to_ee(f_clock, E_reference); // if choice was C, this step gets skipped ...
//  }
//
//exit:;

  say_refclock_freq();
  //    while (Serial.available() > 0) Serial.read();  // clear the Serial buffer  


}

void say_refclock_freq()
{
  Serial.print(F("\r\nRef clock freq: ")); //echo again 
  Serial.println(f_clock,0);
}
// ***************  CALCULATE AD8307 CONSTANTS BELOW   ******************

// by Nick Kennedy, WA5BDU

// NRK --- Add routine to calculate and save calibration constants for AD8307
// As of WA5BDU 1r4, I'll input an rf level (dBm) and read counts (ADC counts) for
// each of any number of test points from the user.  I'll need to keep track of
// their sum, the sum of their squares, the sum of their products, and number
// of input samples from the user. Using linear regression method described here:

// http://science.widener.edu/svb/stats/regress.html

void say_slope_func(void){
  Serial.println(F("\xC0\r   SLOPE/INTERCEPT ENTRY\r"));
}

void constants(){
  float rf; // dBm, value from user input
  float rf_sum; // sum of all dBm inputs
  float rf_sq_sum; // sum of all squared dBm values
  float counts; // current counts read from ADC
  float counts_sum; // sum of all counts for all samples
  float counts_sq_sum; // sum of squares of all counts
  float rf_x_counts; // total of products of all dBm & counts pairs
  float Sxy; // Statistics term: sum of x*y - ((sum x) * (sum y))/Nsamples
  float Sxx; // Statistics term: sum of x^2 - ((sum x)^2)/Nsamples
  float Syy; //                : sum of y^2 - ((sum y)^2)/Nsamples
  // float std_dev;
  float samples; // running total number of test samples
  char anykey; 
  char choice = 'X';
                      //  01234567891234567890123456789
  say_slope_func();
  Serial.println(F("Enter two or more power"));
  Serial.println(F("levels in dBm. The firmware"));
  Serial.println(F("calculates the slope and"));
  Serial.println(F("intercept for the circuit"));
  Serial.println(F("and saves them to EEPROM."));
  say_press();
  Serial.println(F("Y to continue\r "));
  Serial.println(F("M to manually enter values\r "));
  say_quit();

  while((choice = get_char()) == 0x0d);
  say_slope_func();
  if (choice != 'Y' && choice != 'M')
    goto exit;
  if (choice == 'M'){
    manual_slope_int();
    goto exit;
  }

  rf_sum = 0.0; //       Zero out my running totals
  rf_sq_sum = 0.0;
  counts_sum = 0.0;
  counts_sq_sum = 0.0;
  rf_x_counts = 0.0;
  samples = 0.0;

    Serial.println(F("For each point, apply power"));
    Serial.println(F("and enter power level in dBm"));
    Serial.println(F("(enter 100 if finished):\r"));
                    //012345678901234567890123456789
  do{  
    clear_serial_buffer();
    while (Serial.available() == 0); // rev 3.02 addition - prevent timeout waiting 
    rf = Serial.parseFloat();
    if (rf != 100.){
      counts = (float)analogRead(CH0pin);
      Serial.print("dBm = ");
      Serial.print(rf);
      Serial.print(" counts = ");
      Serial.println(counts);

      counts_sum += counts;
      rf_x_counts += rf * counts; // summation of x * y, or (dBm * counts)
      counts_sq_sum += pow(counts, 2.0); //Use pow() NOT ^ for exponent. ^ is XOR
      rf_sum += rf;
      rf_sq_sum += pow(rf, 2.0);
      samples++;
    }else{
      // Here user has input all points, now calculate slope and intercept
      if (samples < 2){
        Serial.println(F("Must be at least two points."));
        Serial.println(F("Exiting ........"));
        delay(2000);
        goto exit;
      }
      Sxy = rf_x_counts - ((counts_sum * rf_sum)/samples);
      Sxx = counts_sq_sum - (pow(counts_sum, 2.0)/samples);
      Syy = rf_sq_sum - (pow(rf_sum, 2.0)/samples);
      slope = Sxy/Sxx;
      intercept = rf_sum/samples - (slope * (counts_sum/samples));
      // std_dev = sqrt((Syy -(pow(slope,2)*Sxx))/(samples-2.0)); // NRK std dev didn't have value
    }
  }while (rf != 100.);
  Serial.print(F("\rslope     = "));
  Serial.println(slope,5);
  Serial.print(F("intercept = "));
  Serial.println(intercept);
  // Serial.print(F("STD Deviation = ")); // 1r5 - std dev had no value
  // Serial.println(std_dev);
  //delay (2000);
  say_press();
  Serial.println(F("Y to write to EEPROM\r "));
  Serial.println(F("N to cancel\r "));	
  while((choice = get_char()) == 0x0d);
//  clear_serial_buffer();
//  while (!Serial.available());
//  choice = toupper(Serial.read());
  if (choice == 'Y')
    slope_int_to_ee(); // write calculated values to ee

exit:;
}
// ****  NRK NRK END of the "calibrate constants" routine **********************


// NRK: Below, function to print slope / intercept from main loop()
// 1r6 change: it also checks for out of range and takes actions ...

void say_slope_int(){
  Serial.println(F("Retrieved:"));

  if (!cal_flag) Serial.println(F("Using default slope/intercept"));
  Serial.print("  slope     = ");
  Serial.println(slope,5);
  Serial.print("  intercept = ");
  Serial.println(intercept);
}

