/* Return Loss Bridge addition to PHSNA
 begun 1/20/2014 - working 1/20/2014
 by Nick Kennedy WA5BDU
 Added in WA5BDU 1r11 which will soon be main revision 3.0, I think ...
 */
// Merged SNA Sweep() with RLB to save program memory space - AD7JT 6/11/2014

// SNA(rlb) is the function called from the main menu ...

void say_rlb_func(){
  Serial.println(F("\xC0\r RETURN LOSS BRIDGE FUNCTIONS\r"));
}

void say_sna_func(){
  Serial.println(F("\xC0\r         SNA FUNCTIONS\r"));
}

void say_press(){
    Serial.println(F("\rPress:\r"));
}

void SNA(int rlb){
  float f_low_local; // note f_low and f_high are global variables ... in kHz
  float f_high_local; // using locals here  ... in kHz
  float f_step_local; // in hertz
  float test_freq;
  float return_loss;
  float swr;
  float rho;

  float os_dBm; // dBm reading with UNKWN open or shorted
  unsigned int counts_old;

  char choice;
  int update; // non-zero means continuously update dBm/SWR at single freq

  if(rlb){
    say_rlb_func();
  }else{
    say_sna_func();
  }
  update = 0;
  say_get_low();
  clear_serial_buffer();
  while (!Serial.available());  // wait for some input
  if(Serial.peek() == 0x0D){
    Serial.read();
  }
  while(!Serial.available());
  while (Serial.peek() != 0x0D){
    f_low_local = Serial.parseFloat();
  }
  Serial.println(f_low_local,3);
  f_low_local *= 1000.;
    
  say_get_high();
  clear_serial_buffer();
  while (Serial.available() == 0);  // wait for some input
  choice = Serial.peek();
  
  if (choice != 0x0D){
    f_high_local = Serial.parseFloat(); 
    Serial.println(f_high_local,3);
    f_high_local *= 1000.; 
      
    say_get_step();
    clear_serial_buffer();
    while (Serial.peek() != 0x0D){
      f_step_local = Serial.parseFloat();  
    }
    Serial.println(f_step_local,0);

  }else{
    clear_serial_buffer();
    f_step_local = 1000.; // to assure just one step
    f_high_local = f_low_local;
    say_press();
    Serial.println(F("Y for continous update\r "));  
    Serial.println(F("N for manual update\r "));   
    while((choice = get_char()) == 0x0d);
    if(choice == 'Y') update = 1;
  }  
  if(rlb){
    // Below, get open / shorted loss
      sendFrequency((f_low_local + f_high_local)/2.); // Put DDS in midband for RLB open-short measurement
      Serial.println(F("\rShort or open the Unknown\rRLB port, then press ENTER."));
      clear_serial_buffer();
      while (!Serial.available()); // stay until user hits a key

      for (int i = 3; i > 0; i--){
        CH0_ADC_counts = analogRead(CH0pin); // throw away some reads
        delay (50);
      }	   
      Serial.print(F("\rReading (dBm) = "));
      CH0_ADC_counts = analogRead(CH0pin);   //read the ADC
      os_dBm = counts_to_dBm();
      Serial.println(os_dBm,1); // as FYI for the user
  }
  
  do{
    if(rlb){
      say_rlb_func();
    }else{
      say_sna_func();
    }
    
    Serial.print(F("\rFREQ LO is: ")); //echo back input data
    Serial.print(f_low_local/1000,3);
    Serial.println(F(" kHz"));
    
    Serial.print(F("FREQ HI is: ")); //echo back input data
    Serial.print(f_high_local/1000,3);
    Serial.println(F(" kHz"));
    
    Serial.print(F("FREQ ST is: "));
    Serial.print(f_step_local,0);
    Serial.println(F(" Hz"));
    
    if(rlb){
      Serial.print(F("Open/short loss: "));
      Serial.print(os_dBm,1);
      Serial.println(F(" dBm"));
      
      Serial.println(F("\r  * * * * ATTACH DUT * * * *"));
    }
    
    say_press();
    if(rlb){
      Serial.println(F("\xe5 - CTRL-V to run\r "));
      Serial.println(F("\xa5 - ALT-V to overwrite\r \r"));
    }else{
      Serial.println(F("\r\xe1 - CTRL-R to run\r "));
      Serial.println(F("\xa1 - ALT-R to overwrite\r \r"));
    }
    say_escape();
    clear_serial_buffer();
    while(!Serial.available());
//    while((choice = get_char()) == 0x0d);
    if(Serial.read()  == 0x1B) return;    
    test_freq = f_low_local;
    sendFrequency(test_freq);
    delay(40);
   if(f_high_local == f_low_local){
      // repeat with single frequency
      Serial.println(F("SINGLE FREQ"));
      delay(2000);
      clear_serial_buffer();
      do{
        say_rlb_func();
        Serial.print(F("FREQ is: ")); 
        Serial.print(f_low_local/1000,3);
        Serial.println(F(" kHz\r"));
        for(int i = 0; i < 16; i++){
          CH0_ADC_counts = analogRead(CH0pin);
          counts_old = CH0_ADC_counts;
          return_loss = os_dBm - counts_to_dBm();
          swr = (pow(10, return_loss/20.)+1)/(pow(10, return_loss/20.)-1);
          Serial.print(F("RL: ")); // return to line start before print
          Serial.print(return_loss,1);
          Serial.print(F("  SWR: "));
          Serial.println(swr,2);
          delay(250); // 4 per second
          if(!update){
            clear_serial_buffer();
            while(!Serial.available());  // wait for user input
            if(Serial.peek()== 0x1B) break;
            clear_serial_buffer();
          }
        }
      }while (!Serial.available()); // stop if user hits key	
    }else{
      // scan the range
       if(rlb){
         Serial.println(F("\rHz, RL, SWR, rho"));
       }else{
         Serial.println(F("\rHz, dBm, counts"));
       }
      do{
        sendFrequency(test_freq);
        Serial.print(test_freq,0);
        comma_space();
        
        CH0_ADC_counts = analogRead(CH0pin);
        if(rlb){	  
          return_loss = os_dBm - counts_to_dBm();
          swr = (pow(10, return_loss/20.)+1)/(pow(10, return_loss/20.)-1);
          rho = (swr-1.)/(swr+1.);
        }else{
          return_loss = counts_to_dBm();
        }
        
        Serial.print(return_loss,2);
        comma_space();
        if(rlb){
          Serial.print(swr,2);
          comma_space();
          Serial.println(rho, 3);
        }else{
          Serial.println(CH0_ADC_counts);   //append the raw ADC counts for reference 
        }
        test_freq += f_step_local;
      }while(test_freq < f_high_local);
    }
    if((get_char() == 0x1B)) return;
  }while(1);   // (toupper(Serial.peek()) == 'Y');		  
exit:;
}


