// ************  PLX-DAQ SWEEP FUNCTION, USE WITH EXCEL SPREADSHEET ****1r6***

// By Jack Generaux W0FNQ, revisions by Nick, WA5BDU


void plx_sweep(){

  int i;
  int xflag = 0;  //
  int o3flag = 0; // flag to use crystal fixture loss factor if != 0
  float short_db = 0.; // loss in crystal fixture
  mode_flag = EEPROM.read(E_mode_flag);// mode flag not reliable at entry - AD7JT

  // Here I'll see if the Excel user has set a flag (CELL O3 = 100)
  // telling me to go back to terminal mode startup.

  clear_serial_buffer();

  Serial.println("CELL,GET,O3");
  delay(100); // If there's no response in 100 ms, I move on ...
  if (Serial.available()){
    xflag = Serial.parseInt();
    if (xflag == 100){
      EEPROM.write(E_mode_flag, 1); // NOT 0 for "normal" mode
      Serial.println(F("MSG,Mode changed to terminal"));
    }
  }

  // First make 30 attempts to contact the spreadsheet and if no success, go
  // back to the terminal mode. One second delay per attempt, so 30s to toggle.

  clear_serial_buffer();
  i=0;
  do{
     // Receipt of Esc character here will terminate PLX mode - AD7JT
    delay(250);
    if(Serial.available() && (Serial.peek() == 0x1B)) goto exit;
    Serial.println("CELL,GET,L2");
    i++;
  }while (Serial.available() == 0 && i < 30);
  if (i == 30) goto exit;
  Serial.println(F("MSG,PHSNA 2.62 - 1.6"));
  clear_serial_buffer();
  Serial.println("CELL,GET,O4"); // if O4 = 100, use crystal loss factor
  while (Serial.available() == 0);  // wait for some input
  while (Serial.peek() != 0x0D) {
    o3flag = Serial.parseInt();
    if (o3flag != 100) o3flag = 0;
  }
  if(o3flag){
    short_db = loss_from_ee(); // read from eeprom, range check below
    if (short_db < -42.5 || short_db > 22.5)
      short_db = 0.0;
  }
  while(!mode_flag){  // 0 => plx mode 
    clear_serial_buffer();
    Serial.println("CELL,GET,L2");
    while (Serial.available() == 0);  // wait for some input
    while (Serial.peek() != 0x0D) {
      if(Serial.peek() == 0x1b) goto exit;
      f_low = Serial.parseFloat();
    }
    clear_serial_buffer();
    Serial.println("CELL,GET,L3"); // this gives me L3
    while (Serial.available() == 0);  // wait for some input
    while (Serial.peek() != 0x0D) {
      if(Serial.peek() == 0x1b) goto exit;
      f_high = Serial.parseFloat();
    }   
    clear_serial_buffer();
    Serial.println("CELL,GET,L4"); // this gives me L4
    while (Serial.available() == 0) ;  // wait for some input
    while (Serial.peek() != 0x0D) {
      if(Serial.peek() == 0x1b) goto exit;
      delta_f = Serial.parseFloat();
    }
    f_low = f_low * 1000.;
    f_high = f_high * 1000.;
    Serial.println(F("CLEARDATA")); // clear data in excel - Moved to here to be in resweep loop - AD7JT
    f_out = f_low;
  
    // NRK 1r6 - for some reason I get a low spike in dBm readings for the
    // first few reads.  I'm going to do a few reads to warm up, and throw
    // them away ..
  
    sendFrequency(f_low);
    for (int i = 3; i > 0; i--){
      CH0_ADC_counts = analogRead(CH0pin); 
      delay (50);
    }
  
    rowssent=0;
    if(xflag){
      Serial.println("LABEL,dBm");
    }else{
      Serial.println("LABEL,FREQ,dBm,counts");
    }
    clear_serial_buffer();
    while(f_out <= f_high){
      sendFrequency(f_out);  // transmit frequency control bytes to DDS
      CH0_ADC_counts = analogRead(CH0pin);   //read the ADC counts
      ///// AD7JT ////// added short data (dBm + 2 characters)
      if(xflag){
        Serial.print("d");
        Serial.println(counts_to_dBm() - short_db); 
      }else{
        Serial.print("DATA,");
        Serial.print(f_out,0);
        comma_space(); 
//        Serial.print(",");
        Serial.print(counts_to_dBm() - short_db); 
        comma_space(); 
//        Serial.print(",");// print the corrected dBm value
        Serial.println(CH0_ADC_counts);
      }
      f_out = f_out + delta_f;   //increment the frequency and repeat
      rowssent += 1;  // Jack's b3 revision
      if(Serial.read() == 0x1B){
        goto exit;                    // Exit PLX operation loop
      }
    }
    Serial.print("CELL,SET,O2,"); // Jack's rev b3
    Serial.println(rowssent); // also rev b3
    char c = 0;
    clear_serial_buffer();
    while(1){
      while (!Serial.available());  // wait for a character or reset
      c = Serial.read();
      if(c == 0x1b){  // Escape terminates PLX mode
        mode_flag = 1;
        break;
      }else if(c == ' '){  // spaced bar repeats PLX sweep
        break; 
      }
    }
  }  // PLX operation loop
  exit:;
  EEPROM.write(E_mode_flag, 1); // NOT 0 for "normal" mode
  mode_flag = 1;
}






